<?php
/* --------------------------------------------------------------
  OnGetProductEanEvent.php 2020-02-21
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Shop\Language\ValueObjects\LanguageId;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetProductEanEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Ean;
use ProductDataInterface;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * Class OnGetProductEanEvent
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events
 */
class OnGetProductEanEvent extends OnGetProductInfoEvent implements OnGetProductEanEventInterface
{
    /**
     * @var Ean
     */
    protected $ean;
    
    
    /**
     * OnGetProductModelEvent constructor.
     *
     * @param ProductDataInterface                  $product
     * @param ProductId                             $productId
     * @param ModifierIdentifierCollectionInterface $modifiers
     * @param LanguageId                            $languageId
     * @param EventDispatcherInterface              $dispatcher
     */
    public function __construct(
        ProductDataInterface $product,
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers,
        LanguageId $languageId,
        EventDispatcherInterface $dispatcher
    ) {
        
        $this->product    = $product;
        $this->productId  = $productId;
        $this->modifiers  = $modifiers;
        $this->languageId = $languageId;
        $this->dispatcher = $dispatcher;
    }
    
    
    /**
     * @inheritDoc
     */
    public function ean() : Ean
    {
        return $this->ean;
    }
    
    
    /**
     * @inheritDoc
     */
    public function setEan(Ean $ean) : void
    {
        $this->ean = $ean;
    }
    
}